<div class="box-header">
    <h1 class="box-title">
        Step 2: <?php echo isset($heading[2]) ? $heading[2] : '' ?>
    </h1>
</div>
<div class="box-body">
    <?php
    if (!empty($type) && !empty($message)) {
        echo pf_alert_message($message, $type);
    }
    ?>
    <form role="form" class="form-horizontal" method="POST">
        <fieldset>
            <legend>Database Settings</legend>
            <div class="form-group <?php echo state_validator('host', $errors); ?>">
                <label for="" class="col-sm-3 control-label">MySQL Hostname</label>
                <div class="col-sm-9">
                    <input type="text" name="host" class="form-control"  value="<?php echo value_input('host') ?>">
                    <?php alert_error_validator('host', $errors); ?>
                </div>
            </div>

            <div class="form-group <?php echo state_validator('user', $errors); ?>">
                <label for="" class="col-sm-3 control-label">MySQL Username</label>
                <div class="col-sm-9">
                    <input type="text" name="user" class="form-control"  value="<?php echo value_input('user') ?>">
                    <?php alert_error_validator('user', $errors); ?>
                </div>
            </div>
            <div class="form-group <?php echo state_validator('pwd', $errors); ?>">
                <label for="" class="col-sm-3 control-label">MySQL Password</label>
                <div class="col-sm-9">
                    <input type="text" name="pwd" class="form-control"  value="<?php echo value_input('pwd') ?>">
                    <?php alert_error_validator('pwd', $errors); ?>
                </div>
            </div>
            <div class="form-group <?php echo state_validator('database', $errors); ?>">
                <label for="" class="col-sm-3 control-label">MySQL Database</label>
                <div class="col-sm-9">
                    <input type="text" name="database" class="form-control"  value="<?php echo value_input('database') ?>">
                    <?php alert_error_validator('database', $errors); ?>
                    <small>Please create a blank database on your hosting control panel</small>
                </div>
            </div>
        </fieldset>
        <fieldset>
            <legend>Site Settings</legend>
            <div class="form-group <?php echo state_validator('site_name', $errors); ?>">
                <label for="" class="col-sm-3 control-label">Site Name</label>
                <div class="col-sm-9">
                    <input type="text" name="site_name" class="form-control"  value="<?php echo value_input('site_name') ?>">
                    <?php alert_error_validator('site_name', $errors); ?>
                </div>
            </div>
        </fieldset>
        <fieldset>
            <legend>Administrator Settings</legend>
            <div class="form-group <?php echo state_validator('email', $errors); ?>">
                <label for="" class="col-sm-3 control-label">Admin Email</label>
                <div class="col-sm-9">
                    <input type="text" name="email" class="form-control"  value="<?php echo value_input('email') ?>">
                    <?php alert_error_validator('email', $errors); ?>
                </div>
            </div>
            <div class="form-group <?php echo state_validator('username', $errors); ?>">
                <label for="" class="col-sm-3 control-label">Admin Username</label>
                <div class="col-sm-9">
                    <input type="text" name="username" class="form-control"  value="<?php echo value_input('username') ?>">
                    <?php alert_error_validator('username', $errors); ?>
                </div>
            </div>
            <div class="form-group <?php echo state_validator('password', $errors); ?>">
                <label for="" class="col-sm-3 control-label">Password</label>
                <div class="col-sm-9">
                    <input type="password" name="password" class="form-control">
                    <?php alert_error_validator('password', $errors); ?>
                </div>
            </div>
            <?php 
                if(empty($errors)){
                    $state = '';
                }elseif(state_validator('confirm', $errors) == 'has-error' || state_validator('same', $errors) == 'has-error'){
                    $state = 'has-error';
                }else{
                    $state = 'has-success';
                }
            ?>
            <div class="form-group <?php echo $state; ?>">
                <label for="" class="col-sm-3 control-label">Re-enter Password</label>
                <div class="col-sm-9">
                    <input type="password" name="confirm" class="form-control">
                    <?php alert_error_validator('confirm', $errors); ?>
                    <?php alert_error_validator('same', $errors); ?>
                </div>
            </div>
            <div class="form-group">
                <div class="col-sm-offset-3 col-sm-9">
                    <a href="?step=1" class="btn btn-default">Back</a>
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </div>
        </fieldset>
    </form>
</div>